/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Callback;
import com.roguewave.chart.core.v2_1.graphics.ClickablePolygon;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.Bar;
import java.awt.Color;
import java.util.Vector;

public abstract class BarChartColumnPart
extends ChartPart {
    protected static final double defaultDepth = 0.8;
    protected static final double defaultWidth = 0.8;
    protected double xSpacing_;
    protected double xCenterStart_;
    protected double zSpacing_;
    protected double zCenterStart_;
    protected double barWidth_;
    protected double barDepth_;

    protected abstract void chartTypeSpecificInit(ChartProperties var1, DataModel var2);

    protected double newYBottom(double lastYBottom, double value) {
        return lastYBottom;
    }

    protected abstract Point3D[] sortPoints(double var1, double var3, double var5);

    public void init(ChartProperties properties, DataModel data, int column, Transform3D transform, int shading) {
        this.chartTypeSpecificInit(properties, data);
        double xCenter = this.xCenterStart_;
        double base = 0.0;
        double yBottom = properties.scaleY(0.0);
        if (yBottom < 0.0) {
            base = -yBottom;
            yBottom = 0.0;
        }
        double zCenter = this.zCenterStart_;
        StandardColors colors = new StandardColors();
        SortTreeNode sortNode = null;
        Vector<ClickablePolygon> twoDClickables = new Vector<ClickablePolygon>();
        Vector<Polygon3D[]> twoDDrawables = new Vector<Polygon3D[]>();
        int rows = data.getRowCount();
        ClickCallbackGenerator callbackGenerator = properties.getClickCallbackGenerator();
        for (int row = 0; row < rows; ++row) {
            SortTreeLeaf stlNew;
            Bar bar;
            double value = properties.getScaledValue(data, row, column);
            Color color = properties.getColor(row, column, colors.color(row), value);
            double height = value - properties.scaleY(0.0) - base;
            Bar bar2 = bar = height > 0.0 ? new Bar(new Point3D(xCenter, yBottom, zCenter), this.barWidth_, this.barDepth_, height, transform, color, shading) : new Bar(new Point3D(xCenter, yBottom + height, zCenter), this.barWidth_, this.barDepth_, -height, transform, color, shading);
            if (callbackGenerator != null) {
                int[] rowArr = new int[]{row};
                int[] colArr = new int[]{column};
                Callback callback = callbackGenerator.generateCallback(data, rowArr, colArr);
                ClickablePolygon clickPoly = new ClickablePolygon(bar.front()[0].zeroZ(), callback);
                twoDClickables.addElement(clickPoly);
                stlNew = new SortTreeLeaf();
                Polygon3D[] polygons = bar.polygons();
                for (int i = 0; i < polygons.length; ++i) {
                    clickPoly = new ClickablePolygon(polygons[i], callback);
                    stlNew.addClickable(clickPoly);
                }
            } else {
                twoDDrawables.addElement(bar.front());
                stlNew = new SortTreeLeaf(bar.polygons());
            }
            Point3D[] testPoints = this.sortPoints(xCenter + this.xSpacing_ / (double)2, yBottom, zCenter + this.zSpacing_ / (double)2);
            for (int i = 0; i < testPoints.length; ++i) {
                testPoints[i] = transform.transform(testPoints[i]);
            }
            sortNode = row == 0 ? stlNew : new SortTreeInternal(sortNode, stlNew, testPoints);
            xCenter += this.xSpacing_;
            yBottom = this.newYBottom(yBottom, height);
            zCenter += this.zSpacing_;
        }
        this.setSortTree(sortNode);
        for (int i = twoDClickables.size() - 1; i >= 0; --i) {
            this.add2DClickable((ClickablePolygon)twoDClickables.elementAt(i));
        }
        for (int i = twoDDrawables.size() - 1; i >= 0; --i) {
            this.add2DPolygons((Polygon3D[])twoDDrawables.elementAt(i));
        }
    }
}

